/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
/*

FUNCTION       : T FLIP-FLOPS WITH ASYNC PRESET AND CLEAR
TRUTHTABLE     : 

              --------------------------------
              prn  clrn   clk    T       q    
              --------------------------------
               L     H      X    X       H 

               H     L      X    X       L
                             _ 
               H     H     _/    L       q 
                             _
               H     H     _/    H       qb
                              
               H     H      L    X       q
              ------------------------------------
*/
`celldefine

`timescale  1ns /  100ps
module tff (clk, prn, clrn, t, q);
	parameter size =1;
	input
		clk,
		prn,
		clrn,
		t;
	output
		q;
    reg
        NOTIFY_REG1;
  reg r_q;
  buf (q,  r_q);

  always @(posedge clk)
    if (t)
	r_q = ~r_q;
    else
	r_q = r_q;
		
  always @(clrn or prn)
    if (clrn == 0)
        assign r_q = 0;
    else if (prn == 0)
            assign r_q = 1;
    else
        deassign r_q;

specify

    // Synthesis parameters
    `ifdef SYNTH
        specparam area = 1;
        specparam capacitance$clk = 1;
        specparam capacitance$clrn = 1;
        specparam capacitance$prn = 1;
        specparam capacitance$t = 1;
    `endif

    // Timing Checks
    $hold(posedge clk,t,1.0);
    $setup(t,posedge clk,1.0);

    // Path Delays
    (clk => q) = (1.0,1.0);
    (prn => q) = (1.0,1.0);
    (clrn => q) = (1.0,1.0);

endspecify

endmodule
`endcelldefine
